﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Security.AntiXss;
using VIRP_WEB.BaseCode;
//using VIRP_WEB.SoaServices;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP_WEB.Custom.EFR
{
    public partial class FragLabResultDetails : EfrBasePage
    {
        private static IReadOnlyList<string> navigationSources = new List<string>
        {
            "/Custom/EFR/LabResults/LabResults.aspx",
            "/Custom/EFR/LabResults/FragmentDetails.aspx",
            "/Custom/EFR/Patients/PatientWorkflows.aspx"
        };

        //private readonly LabResultsManager labResultsManager;
        //private readonly LabOrderManager labOrderManager;
        //private readonly WorkflowCaseManager activityManager;
        //private readonly UserAccountManager userAccountManager;

        //private WKF_CASE_ACTIVITY Activity;
        //private WKF_CASE_ACTIVITY LabOrder;
        //private WKF_CASE_ACTIVITY LabKit;
        //private WKF_CASE WkfCase;
        //private STD_WKFACTIVITYST activitySt;

        private VIRP.CRS.BO.WKF_CASE WkfCase
        {
            get
            {
                VIRP.CRS.BO.WKF_CASE wkfCase = null;

                if (ViewState["WkfCase"] == null)
                {
                    //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(CurrentUser, CurrentRegistryId);
                    ViewState["WkfCase"] = wkfCase;
                }
                else
                {
                    wkfCase = ViewState["WkfCase"] as VIRP.CRS.BO.WKF_CASE;
                }

                return wkfCase;
            }
            set
            {
                ViewState["WkfCase"] = value;
            }
        }

        private VIRP.CRS.BO.WKF_CASE_ACTIVITY Activity
        {
            get
            {
                VIRP.CRS.BO.WKF_CASE_ACTIVITY activity = null;

                if (ViewState["Activity"] == null)
                {
                    //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(CurrentUser, CurrentRegistryId);
                    ViewState["Activity"] = activity;
                }
                else
                {
                    activity = ViewState["Activity"] as VIRP.CRS.BO.WKF_CASE_ACTIVITY;
                }

                return activity;
            }
            set
            {
                ViewState["Activity"] = value;
            }
        }

        private VIRP_WEB.SoaServices.WKF_CASE_ACTIVITY LabOrder
        {
            get
            {
                VIRP_WEB.SoaServices.WKF_CASE_ACTIVITY labOrder = null;

                if (ViewState["LabOrder"] == null)
                {
                    //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(CurrentUser, CurrentRegistryId);
                    ViewState["LabOrder"] = labOrder;
                }
                else
                {
                    labOrder = ViewState["LabOrder"] as VIRP_WEB.SoaServices.WKF_CASE_ACTIVITY;
                }

                return labOrder;
            }
            set
            {
                ViewState["LabOrder"] = value;
            }
        }

        private VIRP_WEB.SoaServices.WKF_CASE_ACTIVITY LabKit
        {
            get
            {
                VIRP_WEB.SoaServices.WKF_CASE_ACTIVITY labKit = null;

                if (ViewState["LabKit"] == null)
                {
                    //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(CurrentUser, CurrentRegistryId);
                    ViewState["LabKit"] = labKit;
                }
                else
                {
                    labKit = ViewState["LabKit"] as VIRP_WEB.SoaServices.WKF_CASE_ACTIVITY;
                }

                return labKit;
            }
            set
            {
                ViewState["LabKit"] = value;
            }
        }

        //private SPECIMEN_ANALYSIS Analysis
        //{
        //    get
        //    {
        //        SPECIMEN_ANALYSIS analysis = null;

        //        if (ViewState["Analysis"] == null)
        //        {
        //            //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(CurrentUser, CurrentRegistryId);
        //            ViewState["Analysis"] = analysis;
        //        }
        //        else
        //        {
        //            analysis = ViewState["Analysis"] as SPECIMEN_ANALYSIS;
        //        }

        //        return analysis;
        //    }
        //    set
        //    {
        //        ViewState["Analysis"] = value;
        //    }
        //}

        private VIRP.CRS.BO.STD_WKFACTIVITYSTS activitySt;

        private int wKFCaseActivityId;

        public FragLabResultDetails()
        {
            //labResultsManager = new LabResultsManager();
            //labOrderManager = new LabOrderManager();
            //activityManager = new WorkflowCaseManager();
            //userAccountManager = (UserAccountManager)HttpContext.Current.User;

            // Manager Save Notification Event Handler
            //labResultsManager.BOSaveSuccess += Manager_BOSaveSuccess;
            //labOrderManager.BOSaveSuccess += Manager_BOSaveSuccess;

            NavigationSources = navigationSources;
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
                wKFCaseActivityId = Convert.ToInt32(AntiXssEncoder.HtmlEncode(Request.QueryString["ActivityId"], false));
            else
                wKFCaseActivityId = Convert.ToInt32(ViewState["ActivityId"]);

            if (!IsPostBack)
            {
                BindData(wKFCaseActivityId, true);

                DisplayLabReportDetails();

                SetReferringPage();
            }

            //TLB TODO: Return to update roles

            //Only TEFSC ADMINISTRATOR or EFR_TEFSC_COORDINATOR can accept Lab Order Results.
            if (!UserSession.IsSystemAdministrator && !UserSession.IsRegistryAdministrator)
            {
                btnComplete.Enabled = false;
            }

            //if (!userAccountManager.GetRoles().Contains((int)VIRP.EFR.BO.RoleCode.EFR_TEFSC_ADMINISTRATOR)
            //    && !userAccountManager.GetRoles().Contains((int)VIRP.EFR.BO.RoleCode.EFR_TEFSC_COORDINATOR))
            //{
            //    btnComplete.Enabled = false;
            //}

            //Per Bug 612: Only TEFSC COORDINATOR can accept or reject Lab Order Results.
            if (!UserSession.IsSystemAdministrator && !UserSession.IsRegistryAdministrator)
            {
                btnReject.Enabled = false;
            }

            //if (!userAccountManager.GetRoles().Contains((int)VIRP.EFR.BO.RoleCode.EFR_TEFSC_COORDINATOR))
            //{
            //    btnReject.Enabled = false;
            //}
        }

        private void BindData(int wkfCaseActivityId, bool fullRefresh)
        {
            //boolean fullRefresh is added since deserialize is not persisting the analysismethod and fragment type values
            WkfCase = VIRP.CRS.BLL.WKF_CASEManager.GetItemByActivity(CurrentUser, CurrentRegistryId, wkfCaseActivityId);
            //WkfCase = labResultsManager.GetLabResultDetails(wkfCaseActivityId);

            //TODO - Check the default value
            //Activity = WkfCase.WKF_CASE_ACTIVITies[0];
            //ViewState["_wCase"] = WkfCase.Serialize();
            Activity = VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.GetItem(CurrentUser, CurrentRegistryId, wkfCaseActivityId); 
            if (Activity != null)
            {
                ChangeHistoryUserControl.WorkFlowCalseId = Activity.WKF_CASE_ID.ToString();
                ChangeHistoryUserControl.ControlWidth = PanelPatient.Width;
            }

            if (!IsPostBack)
            {
                LabOrder = GetLabOrderByCaseId(WkfCase.WKF_CASE_ID);
                //ViewState["Order"] = LabOrder.Serialize();
            }

            if (LabOrder != null)
            {
                LabOrderLink.Visible = true;
                LabOrderLink.NavigateUrl = "~/Custom/EFR/LabOrders/FragLabOrder.aspx?activityId=" + LabOrder.WKF_CASE_ACTIVITY_ID;
            }

            if (Activity != null)
            {
                if (fullRefresh == true)
                {
                    lblFullName.Text = AntiXssEncoder.HtmlEncode(VIRP_WEB.BaseCode.Helpers.FullName(Activity.WKF_CASE.REFERRAL.PATIENT), false); //.FullName;
                    lblICN.Text = AntiXssEncoder.HtmlEncode(Activity.WKF_CASE.REFERRAL.PATIENT.PatientICN, false);
                    lblSnum.Text = AntiXssEncoder.HtmlEncode(Activity.WKF_CASE.REFERRAL.PATIENT.SPATIENT.PatientSnum, false); //.Snum;
                    lblBirthday.Text = ConvertDateToString(Activity.WKF_CASE.REFERRAL.PATIENT.BIRTH_DATE);
                    lblGender.Text = AntiXssEncoder.HtmlEncode(VIRP_WEB.BaseCode.Helpers.GetGender(CurrentUser, CurrentRegistryId, Activity.WKF_CASE.REFERRAL.PATIENT.SPATIENT.STD_GENDER_ID.GetValueOrDefault()), false); //.STD_GENDER.NAME;
                    lblZipCode.Text = AntiXssEncoder.HtmlEncode(Activity.WKF_CASE.REFERRAL.PATIENT.SPATIENT.PostalCode, false); //.POSTAL_CODE;
                    activitySt = Activity.STD_WKFACTIVITYSTS; //.STD_WKFACTIVITYST;
                    ViewState["OrderType"] = activitySt.ID;
                    ViewState["ActivityId"] = Activity.WKF_CASE_ACTIVITY_ID;
                    ViewState["ActivityStName"] = activitySt.NAME;

                    LAB_ORDER order = null;
                    List<LAB_ORDER> orders = LAB_ORDERManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, LabOrder.WKF_CASE_ACTIVITY_ID);
                    if (orders != null && orders.Count > 0)
                    {
                        order = orders.First();
                        LabRptDate.DateValue = ConvertDateToString(order.LAB_REPORT_DATE);
                        txtAccession.Text = order.BSO_NUMBER;
                        txtLabID.Text = order.LAB_ID_NUMBER;
                        txtLabCd.Text = order.METALS_LAB_CODE;
                        FragProdEventDate.DateValue = ConvertDateToString(order.FRAGMENT_PROD_EVENT_DATE);
                    }

                    //if (LabOrder != null && LabOrder.LAB_ORDERs.Count() > 0)
                    //{
                    //    LabRptDate.DateValue = ConvertDateToString(LabOrder.LAB_ORDERs.First().LAB_REPORT_DATE);

                    //    txtAccession.Text = LabOrder.LAB_ORDERs.First().BSO_NUMBER;

                    //    txtLabID.Text = LabOrder.LAB_ORDERs.First().LAB_ID_NUMBER;

                    //    txtLabCd.Text = LabOrder.LAB_ORDERs.First().METALS_LAB_CODE;

                    //    FragProdEventDate.DateValue = ConvertDateToString(LabOrder.LAB_ORDERs.First().FRAGMENT_PROD_EVENT_DATE);
                    //}

                    if (activitySt.ID == Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.New))
                    {
                        btnComplete.Visible = false;
                        btnReject.Visible = true;
                        BtnSave.Text = "Save";

                        List<FRAGMENT_ANALYSIS> analysisList = FRAGMENT_ANALYSISManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, Activity.WKF_CASE_ACTIVITY_ID);
                        if (analysisList == null)
                        {
                            BtnSave.Enabled = false;
                            btnReject.Enabled = false;
                        }

                        //if (Activity.FRAGMENT_ANALYSIs.Count() == 0)
                        //{
                        //    BtnSave.Enabled = false;
                        //    btnReject.Enabled = false;
                        //}
                    }
                    else if (activitySt.ID == Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.InProcess))
                    {
                        btnComplete.Visible = true;
                        btnReject.Visible = true;
                        BtnSave.Text = "Save";
                    }
                    else if (activitySt.ID == Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Accepted))
                    {
                        btnReject.Enabled = false;
                        BtnSave.Text = "Save";
                        CreateFragment.Visible = false;
                        BtnSave.Enabled = false;
                        btnComplete.Enabled = false;
                    }
                    else if (activitySt.ID == Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided))
                    {
                        btnReject.Visible = false;
                        BtnSave.Text = "Un-Void";
                    }
                    UnacceptLabResults(activitySt.ID, Activity.WKF_CASE_ID, btnComplete);
                }

                LabKit = SelectByActivityType(WkfCase.WKF_CASE_ID, "LabKit");
                if (LabKit != null)
                {
                    List<SHIPPING_DETAIL> shipDetailList = SHIPPING_DETAILManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, Activity.WKF_CASE_ACTIVITY_ID);
                    if (shipDetailList != null && shipDetailList.Count > 0)
                    {
                        SHIPPING_DETAIL shipDetail = shipDetailList.First();
                        string kitReceivedDate = shipDetail.RECEIVED_DATE.HasValue ? shipDetail.RECEIVED_DATE.Value.ToString("d") : string.Empty;
                        lblKitReceivedDate.Text = kitReceivedDate;
                        KitReceivedDateHiddenBox.Text = kitReceivedDate;
                    }

                    //var kitReceivedDate = LabKit.RECEIVED_DATE.HasValue ? AntiXssEncoder.HtmlEncode(LabKit.RECEIVED_DATE.Value.ToString("d"), false) : string.Empty;
                    //lblKitReceivedDate.Text = kitReceivedDate;
                    //KitReceivedDateHiddenBox.Text = kitReceivedDate;
                }

                ReplacePageTitle("My Tasks > Lab Results > " + ViewState["ActivityStName"].ToString() + " > Workflow ID " + WkfCase.WKF_CASE_ID.ToString());
            }
        }

        protected void BtnCancel_Click(object sender, EventArgs e)
        {
            RedirectToReferringPage();
        }

        protected void BtnSave_Click(object sender, EventArgs e)
        {
            //Deserialize();
            Activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.InProcess);

            LAB_ORDER order = LAB_ORDERManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, LabOrder.WKF_CASE_ACTIVITY_ID).FirstOrDefault();
            if (order != null)
                SaveResultData(order);
            //SaveResultData(LabOrder.LAB_ORDERs.First());
            //HightlightMenu();

            OpenCloseReferralAndWorkflowCase(WkfCase, () => "Save");

            //SuppressSaveSuccessMessage = true;
            //SuppressSaveSuccessMessage = false;

            //WkfCase is saved in OpenClose function above
            //WkfCase.WKF_CASE_ID = ServiceInterfaceManager.WKF_CASE_SAVE(CurrentUser, CurrentRegistryId, WkfCase);
            //labResultsManager.UpdateResultActivity(WkfCase);

            Activity.WKF_CASE_ACTIVITY_ID = WKF_CASE_ACTIVITYManager.Save(CurrentUser, CurrentRegistryId, Activity);

            BindData(Activity.WKF_CASE_ACTIVITY_ID, true);
            ClientScriptManager cs = Page.ClientScript;

            ClientScript.RegisterStartupScript(this.GetType(), "alertMessage", "<script type='text/javascript'>alert('Save Successful');</script>");
        }

        //private void HightlightMenu()
        //{
        //    //Highlight the corresponding menu item
        //    //BreadCrumbLabel.Text = "Lab Results > In Process";
        //    Menu Mnu = (Menu)Master.FindControl("MenuLeftNavigation");
        //    bool Selected;
        //    MenuBuilder.SelectAndHighLightElement(Mnu.Items, "LabResults.aspx?OrderType=" + Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.InProcess), out Selected);
        //}
        
        protected void CreateFragment_Click(object sender, EventArgs e)
        {
            //Deserialize();

            SaveSessionLabReportDetails();
            Response.Redirect(string.Format("FragmentDetails.aspx?activityId={0}", Activity.WKF_CASE_ACTIVITY_ID), false);
        }

        private void SaveSessionLabReportDetails()
        {
            if (!string.IsNullOrEmpty(LabRptDate.DateValue))
                Session["LabRptDate"] = SessionItemFactory.Create(LabRptDate.DateValue);

            if (!string.IsNullOrEmpty(txtAccession.Text))
                Session["Accession"] = SessionItemFactory.Create(txtAccession.Text);

            if (!string.IsNullOrEmpty(txtLabID.Text))
                Session["LabId"] = SessionItemFactory.Create(txtLabID.Text);

            if (!string.IsNullOrEmpty(txtLabCd.Text))
                Session["LabCode"] = SessionItemFactory.Create(txtLabCd.Text);

            if (!string.IsNullOrEmpty(FragProdEventDate.DateValue))
                Session["EventDate"] = SessionItemFactory.Create(FragProdEventDate.DateValue);
        }

        private void DisplayLabReportDetails()
        {
            var sessionValue = Helpers.SessionItemValueGet(Session["LabRptDate"]);
            if (sessionValue != null)
            {
                LabRptDate.DateValue = sessionValue.ToString();
                Session.Remove("LabRptDate");
            }

            sessionValue = Helpers.SessionItemValueGet(Session["Accession"]);
            if (sessionValue != null)
            {
                txtAccession.Text = sessionValue.ToString();
                Session.Remove("Accession");
            }

            sessionValue = Helpers.SessionItemValueGet(Session["LabId"]);
            if (sessionValue != null)
            {
                txtLabID.Text = sessionValue.ToString();
                Session.Remove("LabId");
            }

            sessionValue = Helpers.SessionItemValueGet(Session["LabCode"]);
            if (sessionValue != null)
            {
                txtLabCd.Text = sessionValue.ToString();
                Session.Remove("LabCode");
            }

            sessionValue = Helpers.SessionItemValueGet(Session["EventDate"]);
            if (sessionValue != null)
            {
                FragProdEventDate.DateValue = sessionValue.ToString();
                Session.Remove("EventDate");
            }
        }

        protected void BtnReject_Click(object sender, EventArgs e)
        {
            //JH 8/11/2010: Per Bug 611: Modifying section to not delete result and place Activity into new status but move to voided

            //Deserialize();
            //Change the Activity status to Voided
            Activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided);
            
            //PrepareFragmentData();
            LAB_ORDER order = LAB_ORDERManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, LabOrder.WKF_CASE_ACTIVITY_ID).FirstOrDefault();
            if (order != null)
                SaveResultData(order);
            //SaveResultData(LabOrder.LAB_ORDERs.First());

            OpenCloseReferralAndWorkflowCase(WkfCase, () => "Void");

            //SuppressSaveSuccessMessage = true;
            //SuppressSaveSuccessMessage = false;

            //WkfCase is saved in OpenClose function above
            //WkfCase.WKF_CASE_ID = ServiceInterfaceManager.WKF_CASE_SAVE(CurrentUser, CurrentRegistryId, WkfCase);
            //labResultsManager.UpdateResultActivity(WkfCase);

            Activity.WKF_CASE_ACTIVITY_ID = WKF_CASE_ACTIVITYManager.Save(CurrentUser, CurrentRegistryId, Activity);

            BindData(Activity.WKF_CASE_ACTIVITY_ID, true);

            ClientScript.RegisterStartupScript(this.GetType(), "alertMessage", "<script type='text/javascript'>alert('Save Successful');</script>");
        }

        /// <summary>
        /// Database update when "Unaccept" button is clicked.
        /// </summary>
        private void UnacceptButtonClick()
        {
            //WorkflowCaseManager wfcManager = new WorkflowCaseManager();

            //Deserialize();

            OpenCloseReferralAndWorkflowCase(WkfCase, () => "Save");

            UnacceptLabResults(Activity, WkfCase);

            Response.Redirect("LabResults.aspx?OrderType=" + Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.InProcess));
        }

        protected void BtnComplete_Click(object sender, EventArgs e)
        {
            if (btnComplete.Text == "Unaccept")
            {
                UnacceptButtonClick();
            }
            else
            {
                //Deserialize();
                //WkfCase.SetAsChangeTrackingRoot(true);
                Activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Accepted);
                //Used for Auto save

                LAB_ORDER order = LAB_ORDERManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, LabOrder.WKF_CASE_ACTIVITY_ID).FirstOrDefault();
                if (order != null)
                    SaveResultData(order);
                //SaveResultData(LabOrder.LAB_ORDERs.First());

                List<FRAGMENT_ANALYSIS> fragments = FRAGMENT_ANALYSISManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, Activity.WKF_CASE_ACTIVITY_ID);
                if (fragments != null)
                {
                    foreach (FRAGMENT_ANALYSIS fragment in fragments)
                    {
                        fragment.RESULT_ACKNOWLEDGE_FLAG = true;
                    }
                }

                //Insert a new Activity for Interpretation if it doesn't exist
                if (GetInterpretationLetterWorkcaseActivity(WkfCase.WKF_CASE_ID, (int)VIRP.EFR.BO.WorkFlowCaseActivityType.InterpretationDiagnosis) == null)
                {
                    WKF_CASE_ACTIVITY InterpretationActivity = CreateNewInterpretationActivity(WkfCase.WKF_CASE_ID);
                    InterpretationActivity.WKF_CASE_ACTIVITY_ID = WKF_CASE_ACTIVITYManager.Save(CurrentUser, CurrentRegistryId, InterpretationActivity);
                    //WkfCase.WKF_CASE_ACTIVITies.Add(InterpreTationActivity);
                    //InterpreTationActivity.SetAsInsertOnSubmit();
                }
                //if (CRS_EFR.Helpers.GetInterpretationLetterWorkcaseActivity(WkfCase.WKF_CASE_ID,
                //       (int)WorkflowCaseManager.WorkFlowCaseActivityType.InterpretationDiagnosis) == null)
                //{
                //    WKF_CASE_ACTIVITY InterpreTationActivity = labResultsManager.CreateNewInterpretationActivity(WkfCase.WKF_CASE_ID);
                //    WkfCase.WKF_CASE_ACTIVITies.Add(InterpreTationActivity);
                //    //InterpreTationActivity.SetAsInsertOnSubmit();
                //}

                OpenCloseReferralAndWorkflowCase(WkfCase, () => "Receive");

                //WkfCase is saved in OpenClose function above
                //WkfCase.WKF_CASE_ID = ServiceInterfaceManager.WKF_CASE_SAVE(CurrentUser, CurrentRegistryId, WkfCase);
                //labResultsManager.UpdateResultActivity(WkfCase);

                //LabOrder.SetAsChangeTrackingRoot();
                if (order != null)
                {
                    LabOrder.STD_WKFACTIVITYSTS_ID = (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Closed;
                    order.LAB_RETURN_DATE = Helpers.ConvertStringToNullable<DateTime>(LabRptDate.DateValue.Trim());
                    order.RESULT_ACKNOWLEDGE_DATE = DateTime.Today;
                    //LabOrder.LAB_ORDERs.First().LAB_RETURN_DATE = CRS_EFR.Helpers.ConvertStringToNullable<DateTime>(LabRptDate.DateValue.Trim());
                    //LabOrder.LAB_ORDERs.First().RESULT_ACKNOWLEDGE_DATE = DateTime.Today;
                    order.LAB_ORDER_ID = LAB_ORDERManager.Save(CurrentUser, CurrentRegistryId, order);
                    //labOrderManager.Update(LabOrder);
                }

                Activity.WKF_CASE_ACTIVITY_ID = WKF_CASE_ACTIVITYManager.Save(CurrentUser, CurrentRegistryId, Activity);

                BindData(Activity.WKF_CASE_ACTIVITY_ID, true);
            }

            ClientScript.RegisterStartupScript(this.GetType(), "alertMessage", "<script type='text/javascript'>alert('Save Successful');</script>");
        }

        private void SaveResultData(LAB_ORDER LabOrder)
        {
            //LabOrder.SetAsChangeTrackingRoot(true);
            LabOrder.LAB_REPORT_DATE = Helpers.ConvertStringToNullable<DateTime>(LabRptDate.DateValue);
            LabOrder.BSO_NUMBER = txtAccession.Text;
            LabOrder.LAB_ID_NUMBER = txtLabID.Text;
            LabOrder.METALS_LAB_CODE = txtLabCd.Text;
            LabOrder.FRAGMENT_PROD_EVENT_DATE = Helpers.ConvertStringToNullable<DateTime>(FragProdEventDate.DateValue);

            LabOrder.LAB_ORDER_ID = LAB_ORDERManager.Save(CurrentUser, CurrentRegistryId, LabOrder);
            //labOrderManager.Update(LabOrder);
        }

        public void Fragments_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Details")
            {
                //Deserialize();

                SaveSessionLabReportDetails();
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewEFRFragments.SelectedIndex = index;
                int id = Convert.ToInt32(GridViewEFRFragments.SelectedValue);
                Response.Redirect(string.Format("FragmentDetails.aspx?activityId={0}&fragmentId={1}", Activity.WKF_CASE_ACTIVITY_ID, id), false);
            }
        }

        //private void Deserialize()
        //{
        //    WkfCase = SerializerUtil.Deserialize<WKF_CASE>((string)ViewState["_wCase"]);
        //    LabOrder = SerializerUtil.Deserialize<WKF_CASE_ACTIVITY>((string)ViewState["Order"]);

        //    Activity = WkfCase.WKF_CASE_ACTIVITies[0];
        //    Activity.SetAsChangeTrackingRoot(true);
        //}

        private void OpenCloseReferralAndWorkflowCase(WKF_CASE parentCase, Func<string> operation)
        {
            //Copied this code from LabKitDetails

            VIRP.CRS.BO.REFERRAL parentReferral = VIRP.CRS.BLL.REFERRALManager.GetItem(CurrentUser, CurrentRegistryId, parentCase.REFERRAL_ID.GetValueOrDefault());
            if (parentReferral != null)
            {
                if (operation() == "Void")
                {
                    List<VIRP_WEB.SoaServices.WKF_CASE> cases = ServiceInterfaceManager.WKF_CASE_GET_ALL_BY_REFERRAL(CurrentUser, CurrentRegistryId, parentReferral.REFERRAL_ID);
                    if (cases != null)
                    {
                        bool blnIncomplete = false;
                        foreach (VIRP_WEB.SoaServices.WKF_CASE c in cases)
                        {
                            if (c.WKF_CASE_ID != parentCase.WKF_CASE_ID && c.STD_WKFCASESTS_ID != (int)VIRP.EFR.BO.WorkFlowCaseStatus.Completed)
                            {
                                blnIncomplete = true;
                                break;
                            }
                        }
                        if (!blnIncomplete)
                        {
                            parentReferral.STD_REFERRALSTS_ID = (int)VIRP.EFR.BO.ReferralStatus.Completed;
                            VIRP.CRS.BLL.REFERRALManager.Save(CurrentUser, CurrentRegistryId, parentReferral);
                        }
                    }

                    parentCase.STD_WKFCASESTS_ID = (int)VIRP.EFR.BO.WorkFlowCaseStatus.Completed;
                    VIRP.CRS.BLL.WKF_CASEManager.Save(CurrentUser, CurrentRegistryId, parentCase);
                }
                else
                {
                    if (parentReferral.STD_REFERRALSTS_ID != (int)VIRP.EFR.BO.ReferralStatus.InProcess)
                    {
                        parentReferral.STD_REFERRALSTS_ID = (int)VIRP.EFR.BO.ReferralStatus.InProcess;
                        VIRP.CRS.BLL.REFERRALManager.Save(CurrentUser, CurrentRegistryId, parentReferral);
                    }

                    if (parentCase.STD_WKFCASESTS_ID != (int)VIRP.EFR.BO.WorkFlowCaseStatus.InProcess)
                    { 
                        parentCase.STD_WKFCASESTS_ID = (int)VIRP.EFR.BO.WorkFlowCaseStatus.InProcess;
                        VIRP.CRS.BLL.WKF_CASEManager.Save(CurrentUser, CurrentRegistryId, parentCase);
                    }
                }

                //SuppressSaveSuccessMessage = true;
                //parentCase.WKF_CASE_ID = ServiceInterfaceManager.WKF_CASE_SAVE(CurrentUser, CurrentRegistryId, parentCase);
                //parentReferral.REFERRAL_ID = ServiceInterfaceManager.REFERRAL_SAVE(CurrentUser, CurrentRegistryId, parentReferral);

                //SuppressSaveSuccessMessage = false;
            }
        }

        //private void OpenCloseReferralAndWorkflowCase(WKF_CASE parentCase, Func<string> operation)
        //{
        //    ReferralManager rm = new ReferralManager();

        //    EFR_REFERRAL parentReferral = rm.getReferralByReferralID(parentCase.REFERRAL_ID.Value);

        //    parentReferral = SerializerUtil.Deserialize<EFR_REFERRAL>(parentReferral.Serialize());
        //    parentReferral.SetAsChangeTrackingRoot();

        //    if (operation() == "Void")
        //    {
        //        var items = parentReferral.WKF_CASEs.Except(new List<WKF_CASE> { parentCase }, new WorkflowCaseManager.WorkflowCaseComparer());

        //        if (items.Count(a => a.STD_WKFCASESTS_ID != (int)VIRP.EFR.BO.WorkFlowCaseStatus.Completed) == 0)

        //            parentReferral.STD_REFERRALSTS_ID = (int)VIRP.EFR.BO.ReferralStatus.Completed;

        //        parentReferral.WKF_CASEs.Where(c => c.WKF_CASE_ID == parentCase.WKF_CASE_ID).First().STD_WKFCASESTS_ID = (int)VIRP.EFR.BO.WorkFlowCaseStatus.Completed;
        //    }
        //    else
        //    {
        //        if (parentReferral.STD_REFERRALSTS_ID != (int)VIRP.EFR.BO.ReferralStatus.InProcess)
        //            parentReferral.STD_REFERRALSTS_ID = (int)VIRP.EFR.BO.ReferralStatus.InProcess;

        //        if (parentCase.STD_WKFCASESTS_ID != (int)VIRP.EFR.BO.WorkFlowCaseStatus.InProcess)
        //            parentReferral.WKF_CASEs.Where(c => c.WKF_CASE_ID == parentCase.WKF_CASE_ID).First().STD_WKFCASESTS_ID = (int)VIRP.EFR.BO.WorkFlowCaseStatus.InProcess;
        //    }

        //    SuppressSaveSuccessMessage = true;
        //    rm.Update(parentReferral);

        //    SuppressSaveSuccessMessage = false;
        //}

        private VIRP_WEB.SoaServices.WKF_CASE_ACTIVITY GetLabOrderByCaseId(int caseId)
        {
            VIRP_WEB.SoaServices.WKF_CASE_ACTIVITY activity = null;

            List<VIRP_WEB.SoaServices.WKF_CASE_ACTIVITY> activityList = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(CurrentUser, CurrentRegistryId, caseId);
            if (activityList != null)
            {
                activity = activityList.Where(acts => acts.STD_WKFACTIVITYTYPE_ID == (int)WorkFlowActivityTypes.LabOrder && acts.ARCHIVED_FLAG == false).FirstOrDefault();
            }
            //using (_db = GetDataContext())
            //{
            //    activity = (from acts in _db.WKF_CASE_ACTIVITies
            //                where acts.WKF_CASE_ID == caseId
            //                && acts.STD_WKFACTIVITYTYPE_ID == (int)WorkFlowActivityTypes.LabOrder
            //                && acts.ARCHIVED_FLAG == false
            //                select acts).FirstOrDefault();
            //    activity.SetAsChangeTrackingRoot();
            //}

            return activity;
        }

        private VIRP_WEB.SoaServices.WKF_CASE_ACTIVITY SelectByActivityType(int caseId, string activityType)
        {
            VIRP_WEB.SoaServices.WKF_CASE_ACTIVITY activity = null;

            List<VIRP_WEB.SoaServices.WKF_CASE_ACTIVITY> activityList = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(CurrentUser, CurrentRegistryId, caseId);
            if (activityList != null)
            {
                WorkFlowActivityTypes type = (WorkFlowActivityTypes)Enum.Parse(typeof(WorkFlowActivityTypes), activityType);
                activity = activityList.Where(acts => acts.STD_WKFACTIVITYTYPE_ID == (int)type).FirstOrDefault();
            }

            //_db = GetDataContext();
            //SetLoadActivityTypeWith(_db);

            //WorkFlowActivityTypes type = (WorkFlowActivityTypes)Enum.Parse(typeof(WorkFlowActivityTypes), activityType);

            //objReturn = SelectByCaseLinqFilter(caseId).Where(e => e.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(type)).FirstOrDefault();
            //_db.Dispose();

            return activity;
        }

        private void UnacceptLabResults(int activityStatusId, int workCaseId, Button button)
        {
            //if (currentUser.GetRoles().Contains((int)RoleCode.EFR_TEFSC_COORDINATOR))
            //{
            button.Enabled = true;
            if (activityStatusId == (int)WorkflowCaseActivityStatus.Accepted)
            {
                button.Text = "Unaccept";

                WKF_CASE_ACTIVITY activity = GetInterpretationLetterWorkcaseActivity(workCaseId, (int)VIRP.EFR.BO.WorkFlowCaseActivityType.InterpretationDiagnosis);

                string message1 = "Are you sure that you want to Unaccept this lab result?";
                string message2 = string.Empty;
                string message3 = string.Empty;
                string message4 = string.Empty;
                string message5 = string.Empty;
                string message6 = string.Empty;
                if (activity != null)
                {
                    if (activity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.InProcess)
                    {
                        message2 = "Intepretation letters have been started but not completed.";
                        message3 = "These letters will be deleted.";
                    }
                    else if (activity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.Interpreted)
                    {
                        message2 = "Interpretation letters have been completed.";
                        message3 = "The contact log has been updated.";
                        message4 = "These letters will be saved as part of the change history for this lab result.";
                        message5 = "A new contact log entry will be created.";
                    }
                }
                button.OnClientClick = "return DisplayWarningMessage('"
                    + message1 + "', '" + message2 + "', '" + message3 + "', '"
                    + message4 + "', '" + message5 + "', '" + message6 + "');";
            }
            else
            {
                button.Text = "Accept";
                button.OnClientClick = "return confirm('Please note that after pressing the Accept button this record will become static (non-editable). Are you sure that you want to accept this lab result?');";
            }
            //}
        }

        private void UnacceptLabResults(WKF_CASE_ACTIVITY labResultsActivity, WKF_CASE workCase)
        {
            //WorkflowCaseManager wfcManager = new WorkflowCaseManager();
            //LabResultsManager labManager = new LabResultsManager();
            bool changeToInprocess = true;

            WKF_CASE_ACTIVITY letterActivity =
                GetInterpretationLetterWorkcaseActivity(labResultsActivity.WKF_CASE_ID,
                (int)VIRP.EFR.BO.WorkFlowCaseActivityType.InterpretationDiagnosis);

            if (letterActivity != null)
            {
                // The letter is in process 
                // Delete the letter record and update the activity record to New as status
                if (letterActivity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.InProcess)
                {
                    //Delete the interpretation letter record 
                    //DeleteInterpreationLetter(letterActivity.WKF_CASE_ACTIVITY_ID);
                    INTERPRETATION_LETTERManager.DeleteByActivity(CurrentUser, CurrentRegistryId, letterActivity.WKF_CASE_ACTIVITY_ID);

                    //Delete interpretation letter activity record
                    ServiceInterfaceManager.WKF_CASE_ACTIVITY_DELETE(CurrentUser, CurrentRegistryId, letterActivity.WKF_CASE_ACTIVITY_ID);
                    //wfcManager.DeleteWorkCaseActivity(letterActivity.WKF_CASE_ACTIVITY_ID);
                }
                // The letter is completed
                else if (letterActivity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.Interpreted)
                {
                    changeToInprocess = false;

                    // Create a new contact log
                    ContactLog lastPrintedContact = Helpers.GetLastPrintedContactLog(CurrentUser, CurrentRegistryId, workCase.REFERRAL_ID.GetValueOrDefault());
                    if (lastPrintedContact != null)
                    {
                        string contactMessage = "Lab results were unaccepted for an Interpretation Letter that was printed by "
                            + lastPrintedContact.ContactInitiator + " on "
                            + lastPrintedContact.ContactDate + ".";

                        CreateNewContactLog((int)workCase.PATIENT_ID, (int)workCase.REFERRAL_ID, EFRSharedConstant.ContactLogReasonUnaccepted, contactMessage, EFRSharedConstant.ContactLogMethodSystem);
                    }

                    // Create a new copy of the current lab results activity 
                    CreateNewCopyOfCurrentLabResults(labResultsActivity.WKF_CASE_ACTIVITY_ID);

                    // Archive the current lab results activity 
                    //UpdateActivityStatus(labResultsActivity.WKF_CASE_ACTIVITY_ID, (int)WorkflowCaseActivityStatus.Accepted, true);
                    labResultsActivity.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.Accepted;
                    labResultsActivity.ARCHIVED_FLAG = true;
                    labResultsActivity.UPDATEDBY = CurrentUser;
                    labResultsActivity.UPDATED = DateTime.Now;
                    VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.Save(CurrentUser, CurrentRegistryId, labResultsActivity);

                    //Archive the interpreted letter 
                    //UpdateActivityStatus(letterActivity.WKF_CASE_ACTIVITY_ID, (int)WorkflowCaseActivityStatus.Interpreted, true);
                    letterActivity.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.Interpreted;
                    letterActivity.ARCHIVED_FLAG = true;
                    letterActivity.UPDATEDBY = CurrentUser;
                    letterActivity.UPDATED = DateTime.Now;
                    VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.Save(CurrentUser, CurrentRegistryId, letterActivity);

                    // Create change history records
                    CreateChangeHistoryRecordsWhenUnaccept(labResultsActivity.WKF_CASE_ID, labResultsActivity.WKF_CASE_ACTIVITY_ID, letterActivity.WKF_CASE_ACTIVITY_ID);
                }
            }

            if (changeToInprocess)
            {
                //Change the activity status to In Process
                //UpdateActivityStatus(labResultsActivity.WKF_CASE_ACTIVITY_ID, (int)WorkflowCaseActivityStatus.InProcess, false);
                labResultsActivity.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.InProcess;
                labResultsActivity.ARCHIVED_FLAG = false;
                VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.Save(CurrentUser, CurrentRegistryId, labResultsActivity);
            }
        }

        /// <summary>
        /// Get the work flow case activity record for interpretation letter
        /// </summary>
        /// <param name="workcaseId"></param>
        /// <param name="activityTypeId"></param>
        /// <returns></returns>
        private WKF_CASE_ACTIVITY GetInterpretationLetterWorkcaseActivity(int workcaseId, int activityTypeId)
        {
            WKF_CASE_ACTIVITY activity = null;

            List<WKF_CASE_ACTIVITY> activityList = VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.GetitemsByWorkflowCaseId(CurrentUser, CurrentRegistryId, workcaseId);
            //ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(CurrentUser, CurrentRegistryId, workcaseId);
            if (activityList != null)
            {
                activity = activityList.Where(acts => acts.STD_WKFACTIVITYTYPE_ID == activityTypeId).FirstOrDefault();
            }

            return activity;
            //WorkflowCaseManager wfcManager = new WorkflowCaseManager();
            //return wfcManager.SelectByCaseIdAndActivityTypeId(workcaseId, activityTypeId);
        }

        /// <summary>
        /// Insert a new record to LABRESULT_CHANGE_TRACKING table
        /// </summary>
        /// <param name="changeTracking"></param>
        /// 
        private void CreatOneChangeHistoryRecord(LABRESULT_CHANGE_TRACKING changeTracking)
        {
            changeTracking.LABRESULT_CHANGE_TRACKING_ID = LABRESULT_CHANGE_TRACKINGManager.Save(CurrentUser, CurrentRegistryId, changeTracking);
            //LabResultsTrackingManager manager = new LabResultsTrackingManager();
            //changeTracking.SetAsChangeTrackingRoot();
            //changeTracking.SetAsInsertOnSubmit();
            //manager.Update(changeTracking);
        }

        /// <summary>
        /// Update work flow case activity record with status and archived flag
        /// </summary>
        /// <param name="activityId"></param>
        /// <param name="statusId"></param>
        /// <param name="archived"></param>
        /// <returns></returns>
        //private void UpdateActivityStatus(int activityId, int statusId, bool archived)
        //{
        //    WKF_CASE_ACTIVITY activity = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET(CurrentUser, CurrentRegistryId, activityId);
        //    activity.STD_WKFACTIVITYSTS_ID = statusId;
        //    activity.ARCHIVED_FLAG = archived;
        //    activity.WKF_CASE_ACTIVITY_ID = ServiceInterfaceManager.WKF_CASE_ACTIVITY_SAVE(CurrentUser, CurrentRegistryId, activity);
        //}

        /// <summary>
        /// Create a new copy of lab results and insert to the database
        /// This is for archive the current copy of the lab results.
        /// </summary>
        /// <param name="activityId"></param>
        /// <returns></returns>
        private void CreateNewCopyOfCurrentLabResults(int activityId)
        {
            WKF_CASE_ACTIVITY activity = VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.GetItem(CurrentUser, CurrentRegistryId, activityId);
            {
                activity.WKF_CASE_ACTIVITY_ID = 0;
                activity.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.InProcess;
                activity.WKF_CASE_ACTIVITY_ID = VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.Save(CurrentUser, CurrentRegistryId, activity);

                List<LAB_ORDER> orders = LAB_ORDERManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, activityId);
                if (orders != null)
                {
                    foreach (LAB_ORDER order in orders)
                    {
                        order.LAB_ORDER_ID = 0;
                        order.WKF_CASE_ACTIVITY_ID = activity.WKF_CASE_ACTIVITY_ID;
                        order.LAB_ORDER_ID = LAB_ORDERManager.Save(CurrentUser, CurrentRegistryId, order);
                    }
                }

                List<SPECIMEN_ANALYSIS> analysisList = SPECIMEN_ANALYSISManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, activityId);
                if (analysisList != null)
                {
                    foreach (SPECIMEN_ANALYSIS analysis in analysisList)
                    {
                        int tempAnalysisId = analysis.SPECIMEN_ANALYSIS_ID;
                        analysis.SPECIMEN_ANALYSIS_ID = 0;
                        analysis.UPDATEDBY = CurrentUser;
                        analysis.WKF_CASE_ACTIVITY_ID = activity.WKF_CASE_ACTIVITY_ID;
                        analysis.SPECIMEN_ANALYSIS_ID = SPECIMEN_ANALYSISManager.Save(CurrentUser, CurrentRegistryId, analysis);

                        List<ANALYSIS_DETAIL> detailList = ANALYSIS_DETAILManager.GetItemsBySpecimen(CurrentUser, CurrentRegistryId, tempAnalysisId);

                        if (detailList != null)
                        {
                            foreach (ANALYSIS_DETAIL detail in detailList)
                            {
                                detail.ANALYSIS_DETAIL_ID = 0;
                                detail.UPDATEDBY = CurrentUser;
                                detail.SPECIMEN_ANALYSIS_ID = analysis.SPECIMEN_ANALYSIS_ID;
                                detail.ANALYSIS_DETAIL_ID = ANALYSIS_DETAILManager.Save(CurrentUser, CurrentRegistryId, detail);
                            }
                        }
                    }
                }

                List<FRAGMENT_ANALYSIS> fragmentList = FRAGMENT_ANALYSISManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, activityId);
                if (fragmentList != null)
                {
                    foreach (FRAGMENT_ANALYSIS fragment in fragmentList)
                    {
                        int tempFragmentId = fragment.FRAGMENT_ANALYSIS_ID;
                        fragment.FRAGMENT_ANALYSIS_ID = 0;
                        fragment.UPDATEDBY = CurrentUser;
                        fragment.WKF_CASE_ACTIVITY_ID = activity.WKF_CASE_ACTIVITY_ID;
                        fragment.FRAGMENT_ANALYSIS_ID = FRAGMENT_ANALYSISManager.Save(CurrentUser, CurrentRegistryId, fragment);

                        List<ANALYSIS_DETAIL> detailList = ANALYSIS_DETAILManager.GetItemsByFragmentExact(CurrentUser, CurrentRegistryId, tempFragmentId);

                        if (detailList != null)
                        {
                            foreach (ANALYSIS_DETAIL detail in detailList)
                            {
                                detail.ANALYSIS_DETAIL_ID = 0;
                                detail.UPDATEDBY = CurrentUser;
                                detail.FRAGMENT_ANALYSIS_ID = fragment.FRAGMENT_ANALYSIS_ID;
                                detail.ANALYSIS_DETAIL_ID = ANALYSIS_DETAILManager.Save(CurrentUser, CurrentRegistryId, detail);
                            }
                        }
                    }
                }
            }

            //WKF_CASE_ACTIVITY labResults = null;
            //using (_db = GetDataContext())
            //{
            //    SetLoadwithForLabResultsCreateNewCopy(_db);
            //    labResults = (from c in _db.WKF_CASE_ACTIVITies
            //                  where c.WKF_CASE_ACTIVITY_ID == activityId
            //                  select c).FirstOrDefault();
            //    labResults.SetAsChangeTrackingRoot();
            //}

            //WKF_CASE_ACTIVITY newLab = labResults.Clone();
            //newLab.SetAsChangeTrackingRoot();
            //newLab.SetAsInsertOnSubmit();
            //newLab.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.InProcess;

            //foreach (SPECIMEN_ANALYSI specimen in newLab.SPECIMEN_ANALYSIs)
            //{
            //    foreach (ANALYSIS_DETAIL detail in specimen.ANALYSIS_DETAILs)
            //    {
            //        detail.SetAsInsertOnSubmit();
            //    }
            //    specimen.SetAsInsertOnSubmit();
            //}

            //foreach (FRAGMENT_ANALYSI fragment in newLab.FRAGMENT_ANALYSIs)
            //{
            //    foreach (ANALYSIS_DETAIL detail in fragment.ANALYSIS_DETAILs)
            //    {
            //        detail.SetAsInsertOnSubmit();
            //    }
            //    fragment.SetAsInsertOnSubmit();
            //}

            //using (_db = GetDataContext())
            //{
            //    _db.DeferredLoadingEnabled = false;
            //    newLab.SynchroniseWithDataContext(_db, true);

            //    try
            //    {
            //        _db.SubmitChanges(ConflictMode.ContinueOnConflict);
            //        returnStatus = 0;

            //    }
            //    catch (ChangeConflictException)
            //    {
            //        _db.ChangeConflicts.ResolveAll(RefreshMode.KeepChanges);
            //        returnStatus = 0;
            //    }
            //    catch
            //    {
            //        returnStatus = -1;
            //    }
            //}
        }

        /// <summary>
        /// Create three new change history records when unaccepting a lab result
        /// </summary>
        /// <param name="workCaseId"></param>
        /// <param name="labActivityId"></param>
        /// <param name="interpreationActivityId"></param>
        private void CreateChangeHistoryRecordsWhenUnaccept(int workCaseId, int labActivityId, int interpreationActivityId)
        {
            LABRESULT_CHANGE_TRACKING changeHistory = null;
            string url = string.Empty;

            // Provider letter archived
            url = string.Format("../LabResultsInterpretationLetters.aspx?activityId={0}&intActivityId={1}&RptType={2}&CaseId={3}", labActivityId, interpreationActivityId, "1", workCaseId);
            changeHistory = CreateNewChangeHistoryObject(workCaseId, EFRSharedConstant.LabResultsChangeHistoryProviderLetterArchived, url);
            CreatOneChangeHistoryRecord(changeHistory);

            // Patient letter archived
            url = string.Format("../LabResultsInterpretationLetters.aspx?activityId={0}&intActivityId={1}&RptType={2}&CaseId={3}", labActivityId, interpreationActivityId, "0", workCaseId);
            changeHistory = CreateNewChangeHistoryObject(workCaseId, EFRSharedConstant.LabResultsChangeHistoryPatientLetterArchived, url);
            CreatOneChangeHistoryRecord(changeHistory);

            // Unaccept contact log created
            changeHistory = CreateNewChangeHistoryObject(workCaseId, EFRSharedConstant.LabResultsChangeHistoryContactLogCreated, string.Empty);
            CreatOneChangeHistoryRecord(changeHistory);
        }

        private WKF_CASE_ACTIVITY CreateNewInterpretationActivity(int caseId)
        {
            WKF_CASE_ACTIVITY Activity = new WKF_CASE_ACTIVITY();
            Activity.CREATED = Activity.UPDATED = DateTime.Now;
            Activity.CREATEDBY = Activity.UPDATEDBY = CurrentUser;
            Activity.WKF_CASE_ID = caseId;
            Activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.New);
            Activity.STD_WKFACTIVITYTYPE_ID = Convert.ToInt16(WorkFlowActivityTypes.Interpretation);
            Activity.REPRESENTATIVE_NAME = string.Empty;
            return Activity;
        }

        /// <summary>
        /// Create a new change history object
        /// </summary>
        /// <param name="workCaseId"></param>
        /// <param name="descriptionText"></param>
        /// <param name="navigationUrl"></param>
        /// <returns></returns>
        private static LABRESULT_CHANGE_TRACKING CreateNewChangeHistoryObject(int workCaseId, string descriptionText, string navigationUrl)
        {
            LABRESULT_CHANGE_TRACKING changeHistory = new LABRESULT_CHANGE_TRACKING();

            changeHistory.WKF_CASE_ID = workCaseId;
            changeHistory.CHANGE_DATE = DateTime.Now;
            changeHistory.CHANGE_DESCRIPTION = descriptionText;
            if (!string.IsNullOrEmpty(navigationUrl))
            {
                changeHistory.NAVIGATION_URL = navigationUrl;
            }

            return changeHistory;
        }

        private void CreateNewContactLog(int patientId, int referralId, string reason, string contactMessage, string contactMethod)
        {
            //Get Patient
            //PatientManager patientManager = new PatientManager();
            //PATIENT patient = patientManager.SelectByPatientID(patientId);
            PATIENT patient = VIRP.CRS.BLL.PATIENTManager.GetItem(CurrentUser, CurrentRegistryId, patientId);
            PATIENT_REG patientReg = VIRP.CRS.BLL.PATIENT_REGManager.GetItem(CurrentUser, CurrentRegistryId, patientId);

            //Populate new contact log object
            CONTACT_LOG contact = new CONTACT_LOG();

            contact.REFERRAL_ID = referralId;
            contact.CONTACT_FIRST_NAME = patient.FIRST_NAME;
            contact.CONTACT_LAST_NAME = patient.LAST_NAME;
            contact.CONTACT_DATE = DateTime.Now;
            contact.CONTACT_METHOD_TEXT = contactMethod;
            contact.CONTACT_EMAIL = null;
            contact.CONTACT_ADDR1 = patientReg.ADDRESS_LINE1;
            contact.CONTACT_ADDR2 = patientReg.ADDRESS_LINE2;
            contact.CONTACT_ADDR3 = patientReg.ADDRESS_LINE3;
            contact.CONTACT_CITY = patientReg.CITY;
            contact.CONTACT_STATE = patientReg.STATE;
            contact.CONTACT_POSTAL = patientReg.POSTAL_CODE;
            contact.CONTACT_ZIPPLUS4 = patientReg.ZIP_PLUS_4;
            contact.CONTACT_COUNTRY = patientReg.COUNTRY;
            contact.CONTACT_REASON_TEXT = reason;
            contact.TELEMEDICINE_PATIENT_FLAG = false;
            contact.TELEMEDICINE_PROVIDER_FLAG = false;
            contact.INPATIENT_EVAL_RECOM_FLAG = false;
            contact.CONTACT_MESSAGE_TEXT = contactMessage;

            contact.CONTACT_LOG_ID = CONTACT_LOGManager.Save(CurrentUser, CurrentRegistryId, contact);

            //contact.SetAsChangeTrackingRoot();
            //contact.SetAsInsertOnSubmit();

            //ContactLogManager manager = new ContactLogManager();
            //manager.Update(contact);
        }

        protected override void Ds_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);

            try
            {
                //e.InputParameters.Clear();

                //string txtSearch = TextBoxSearchCriteria.Text;
                //string listFacility = DropDownListFacility.SelectedValue;

                if (e.InputParameters["CURRENT_USER"] != null)
                    e.InputParameters["CURRENT_USER"] = HttpContext.Current.User.Identity.Name;
                else
                    e.InputParameters.Add("CURRENT_USER", HttpContext.Current.User.Identity.Name);

                if (e.InputParameters["CURRENT_REGISTRY_ID"] != null)
                    e.InputParameters["CURRENT_REGISTRY_ID"] = UserSession.CurrentRegistryId;
                else
                    e.InputParameters.Add("CURRENT_REGISTRY_ID", UserSession.CurrentRegistryId);

                //e.InputParameters.Add("lastName", txtSearch);
                //e.InputParameters.Add("facilityId", listFacility);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);
                throw ex;
            }
        }
    }
}
